/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlock;
import com.yuushya.block.AttachmentBlock;
import com.yuushya.block.CableBlock;
import com.yuushya.block.CompactBlock;
import com.yuushya.block.FaceBlock;
import com.yuushya.block.LineBlock;
import com.yuushya.block.NormalBlock;
import com.yuushya.block.PoleBlock;
import com.yuushya.block.RepeatBlock;
import com.yuushya.block.TriPartBlock;
import com.yuushya.block.TubeBlock;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.entity.ChairEntityUtils;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YuushyaBlockFactory {
    private static final Map<Integer, VoxelShape> yuushyaVoxelShapes = new HashMap<Integer, VoxelShape>();

    public static Map<Integer, VoxelShape> getYuushyaVoxelShapes() {
        return yuushyaVoxelShapes;
    }

    public static BlockBehaviour.Properties getBlockProperties(BlockBehaviour.Properties blockProperties, YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        blockProperties = blockProperties.m_60913_(yuushyaBlockProperties.hardness, yuushyaBlockProperties.resistance);
        if (yuushyaBlockProperties.sound != null && !yuushyaBlockProperties.sound.isEmpty()) {
            blockProperties = blockProperties.m_60918_(YuushyaUtils.toSound(yuushyaBlockProperties.sound));
        }
        if (yuushyaBlockProperties.lightLevel != 0) {
            blockProperties = blockProperties.m_60953_(state -> yuushyaBlockProperties.lightLevel);
        }
        if (!yuushyaBlockProperties.hasCollision) {
            blockProperties = blockProperties.m_60910_();
        }
        if (yuushyaBlockProperties.isDelicate) {
            blockProperties = blockProperties.m_60966_();
        }
        if (!yuushyaBlockProperties.isSolid) {
            blockProperties = blockProperties.m_60955_();
        }
        if (yuushyaBlockProperties.offset != null) {
            blockProperties = blockProperties.m_222979_(YuushyaUtils.toOffsetType(yuushyaBlockProperties.offset));
        }
        return blockProperties;
    }

    public static BlockBehaviour.Properties getBlockProperties(YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        if (yuushyaBlockProperties == null) {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_);
        }
        BlockBehaviour.Properties blockProperties = BlockBehaviour.Properties.m_60939_((Material)YuushyaUtils.toBlockMaterial(yuushyaBlockProperties.material));
        return YuushyaBlockFactory.getBlockProperties(blockProperties, yuushyaBlockProperties);
    }

    private static List<? extends Property<?>> getBlockStateProperties(YuushyaRegistryData.Block.BlockState yuushyaBlockState) {
        if (yuushyaBlockState == null || yuushyaBlockState.states == null) {
            return List.of();
        }
        return yuushyaBlockState.states.stream().map(YuushyaBlockStates::toBlockStateProperty).toList();
    }

    public static Block create(YuushyaRegistryData.Block yuushyaBlock) {
        return YuushyaBlockFactory.create(YuushyaBlockFactory.getBlockProperties(yuushyaBlock.properties), yuushyaBlock);
    }

    public static Block create(BlockBehaviour.Properties properties, final YuushyaRegistryData.Block yuushyaBlock) {
        if (yuushyaBlock.autoGenerated == null) {
            yuushyaBlock.autoGenerated = new YuushyaRegistryData.Block.AutoGenerated();
            yuushyaBlock.autoGenerated.collision = "block";
        }
        if (yuushyaBlock.blockstate.kit != null && !yuushyaBlock.blockstate.kit.isEmpty()) {
            switch (yuushyaBlock.blockstate.kit) {
                case "normal": {
                    return new NormalBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "attachment": {
                    return new AttachmentBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "line": {
                    return new LineBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "face": {
                    return new FaceBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "pole": {
                    return new PoleBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "tri_part": {
                    return new TriPartBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "tube": {
                    return new TubeBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "compact": {
                    return new CompactBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "repeat": {
                    return new RepeatBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "block": {
                    break;
                }
                case "VanillaSlabBlock": {
                    return new SlabBlock(properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaDoorBlock": {
                    return new DoorBlock(properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaStairBlock": {
                    BlockState blockState = Blocks.f_50705_.m_49966_();
                    if (yuushyaBlock.properties.parent != null) {
                        blockState = yuushyaBlock.properties.parent.contains(":") ? ((Block)Registry.f_122824_.m_7745_(new ResourceLocation(yuushyaBlock.properties.parent))).m_49966_() : ((Block)YuushyaRegistries.BLOCKS.get(yuushyaBlock.properties.parent).get()).m_49966_();
                    }
                    return new StairBlock(blockState, properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
            }
        }
        final List<? extends Property<?>> blockStateProperties = YuushyaBlockFactory.getBlockStateProperties(yuushyaBlock.blockstate);
        switch (yuushyaBlock.classType) {
            case "CableBlock": {
                return new CableBlock(properties, yuushyaBlock.properties.lines, "CableBlock", yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
            }
            case "": {
                return new Block(properties);
            }
        }
        return new BlockWithClassType(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage){
            {
                super(properties, tipLines, classType, autoCollision, usage);
                this.m_49959_(YuushyaBlockStates.getDefaultBlockState((BlockState)this.f_49792_.m_61090_()));
            }

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
                stateBuilder.m_61104_((Property[])blockStateProperties.toArray(Property[]::new));
            }

            @Nullable
            public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
                BlockState res = this.m_49966_();
                if (blockStateProperties.contains(BlockStateProperties.f_61376_) && blockStateProperties.contains(BlockStateProperties.f_61374_)) {
                    Direction direction = blockPlaceContext.m_7820_();
                    res = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)res.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)((BlockState)res.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction.m_122424_());
                }
                return res;
            }

            public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
                return blockState;
            }
        };
    }

    public static boolean isTheSameBlock(BlockState state1, BlockState state2) {
        return state2.m_60734_() == state1.m_60734_();
    }

    public static boolean isTheSameFacing(BlockState blockState1, BlockState blockState2) {
        return blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == blockState2.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public static boolean isTheSameLine(BlockState blockState1, BlockState blockState2) {
        return blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == blockState2.m_61143_((Property)BlockStateProperties.f_61374_) || blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == ((Direction)blockState2.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
    }

    public static class BlockWithClassType
    extends AbstractYuushyaBlock {
        public String classType;
        public String autoCollision;
        public YuushyaRegistryData.Block.Usage usage;
        private final Map<BlockState, VoxelShape> voxelShapeCache = new HashMap<BlockState, VoxelShape>();

        public BlockWithClassType(BlockBehaviour.Properties properties, Integer tipLines, String classType, String autoCollision, YuushyaRegistryData.Block.Usage usage) {
            super(properties, tipLines);
            this.classType = classType;
            this.autoCollision = autoCollision;
            this.usage = usage;
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (this.usage != null) {
                if (!level.f_46443_ && this.usage.sound != null && !this.usage.sound.isBlank() && player.m_21120_(hand).m_41619_()) {
                    SoundEvent soundEvent = (SoundEvent)Registry.f_122821_.m_7745_(new ResourceLocation(this.usage.sound));
                    level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 0.2f);
                }
                if (this.usage.sitPos != null && this.usage.sitPos.size() == 3 && player.m_21120_(hand).m_41619_()) {
                    return ChairEntityUtils.use(new Vec3((double)this.usage.sitPos.get(0).floatValue(), (double)this.usage.sitPos.get(1).floatValue(), (double)this.usage.sitPos.get(2).floatValue()), state, level, pos, player, hand, hit);
                }
                if (this.usage.cycleForms != null && !this.usage.cycleForms.isEmpty() && player.m_21120_(hand).m_41619_()) {
                    while (!this.usage.cycleForms.contains((state = (BlockState)state.m_61122_((Property)YuushyaBlockStates.FORM)).m_61143_((Property)YuushyaBlockStates.FORM))) {
                    }
                    level.m_7731_(pos, state, 2);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        }

        public boolean isTheSameType(BlockWithClassType block) {
            return this.classType.equals(block.classType);
        }

        public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
            if (!this.voxelShapeCache.containsKey(blockState)) {
                if (!YuushyaBlockFactory.getYuushyaVoxelShapes().containsKey(Block.m_49956_((BlockState)blockState))) {
                    CollisionFileReader.readCollisionToVoxelShape(this.voxelShapeCache, blockState.m_60734_(), Registry.f_122824_.m_7981_((Object)blockState.m_60734_()).toString());
                }
                VoxelShape shape = YuushyaBlockFactory.getYuushyaVoxelShapes().getOrDefault(Block.m_49956_((BlockState)blockState), Shapes.m_83040_());
                this.voxelShapeCache.put(blockState, shape);
                return shape;
            }
            return this.voxelShapeCache.get(blockState);
        }

        public BlockState m_6843_(BlockState state, Rotation rotation) {
            if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            return super.m_6843_(state, rotation);
        }

        public BlockState m_6943_(BlockState state, Mirror mirror) {
            if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            return super.m_6943_(state, mirror);
        }
    }
}

